package gov.va.med.mhv.calendar.repository;

import java.util.List;

import gov.va.med.mhv.calendar.model.AppointmentReminder;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AppointmentReminderRepository extends JpaRepository<AppointmentReminder, Long> {

	@Query("select appointmentReminder from AppointmentReminder appointmentReminder " +
			   "where appointmentReminder.reminderState = 0 ")
	public List<AppointmentReminder> getScheduledAppointmentRemindersForDateRange();
	
	@Query("select appointmentReminder from AppointmentReminder appointmentReminder " +
			   "where appointmentReminder.patientId = :patientId ")
	public List<AppointmentReminder> getScheduledAppointmentRemindersForPatient(@Param("patientId") Long patientId);

	
}
